VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CDBConvert"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

'Set module name for easiler error handling/message display
Const Module = "CDBConvert"

'Database format constants - start from 0 sequentially
'to make it easy to load to a combo box
Public Enum CDBConvertDBFormatEnum
    [Access 2000] = 0
    [CSV File] = 1
    [dBase III] = 2
    [dBase IV] = 3
    [dBase V] = 4
    [Excel 2000] = 5
    [Html Document] = 6
    [Text File] = 7
End Enum

'Status change constants - used to when raising OnStatusChange event.
Public Enum CDBConvertStatusMsgEnum
    [Conversion Initial Ready] = 1
    [Conversion Preparing Start] = 10
    [Conversion Preparing Proceeding] = 11
    [Conversion Preparing End] = 12
    [Conversion Start] = 20
    [Conversion Proceeding] = 21
    [Conversion Proceeding Connect to Source] = 22
    [Conversion Proceeding Write to Destination] = 23
    [Conversion Complete] = 40
    [Conversion Error] = -1
    [Conversion Preparing Error] = -2
End Enum

'Public events - which allows the main form to display
'the status messages and error message
'under its own control.

'Raised when status changes.
Public Event OnStatusChange(MsgText, Msg As CDBConvertStatusMsgEnum)
'Raised when a conversion starts.
Public Event OnStart(MsgText, Source As String, Destination As String)
'Raised when a conversion completes successfully.
Public Event OnComplete(MsgText, Source As String, Destination As String)
'Raised when an error occurs.
Public Event OnError(MsgText)

'Private constants
Private mlngSourceFormat As CDBConvertDBFormatEnum 'source format
Private mlngDestinationFormat As CDBConvertDBFormatEnum 'desitnation format
Private mstrSource As String 'source full path
Private mstrDestination As String 'destination full path
Private mstrSourceTable As String 'selected source table used in conversion - this can be Empty
Private mstrDestinationTable As String 'selected destination table used in conversion - this can be Empty
Private mcboSourceCombo As VB.ComboBox 'Combobox to load source table names
Private mcboDestinationCombo As VB.ComboBox 'Combobox to load destination table names
Private mboolErrorMsgBoxEnabled As Boolean 'Allows the user to turn off error msgbox display.
Private mboolSuccessMsgBoxEnabled As Boolean 'Allows the user to turn off the operation success message display.
                        'Actually, there is obny one sucessful message in this class - "conversion complete".
Private mstrErrorDetail As String 'Saves detailed error description with procedure and module names
                        'for easier check
Private mstrMsgDetail As String 'Detailed messages.
Private mstrConnectStringExecuted As String 'Excuted connect string. Useful for debugging and comparison
Private mstrConvertSQLExecuted As String 'Excuted SQL. Useful for debugging and comparison

Private Sub Class_Initialize()
    'Turns off erros message box displays
    Me.ErrorMsgBoxEnabled = False
    'Truns off success message box displays.
    Me.SuccessMsgBoxEnabled = False
    'Event if your turns off, the neccessary error & success messages
    'return with events, OnError, OnComplete, OnStatusChange.....
    'And, you can display the messaage on a status bar.
End Sub

Private Sub Class_Terminate()
    'Clean up
    Set mcboSourceCombo = Nothing
    Set mcboDestinationCombo = Nothing
End Sub

'-------------------------------------------------------------------------------
' Allows loding the form, frmForm, from the class
' Necessarry when you turn this project into a DLL.
'-------------------------------------------------------------------------------
Public Sub LoadDatabaseConvertWindow( _
    Optional frmOwner As Object, _
    Optional ShowMode As VBRUN.FormShowConstants = vbModeless)
    
    'Error handling is necessary
    'because IDE do not allows the form to be shown vbModal
    'when this project is turned into a DLL.
    On Error GoTo Err_Handle
    
    Load frmMain
    If frmOwner Is Nothing Then
        frmMain.Show
    ElseIf ShowMode <> vbModal And ShowMode <> vbModeless Then
        frmMain.Show
    Else
        frmMain.Show vbModal, frmOwner
    End If
    DoEvents
    
    
Exit_Proc:
    Exit Sub
    
ResumeAgain: 'if the modal display fails, just show it.
    frmMain.Show
    DoEvents
    Exit Sub
    
Err_Handle:
    'if error occurs more than one times, exit always
    Static ErrCount As Long
    ErrCount = ErrCount + 1
    If ErrCount > 1 Then ErrCount = 0: Exit Sub
    Resume ResumeAgain
End Sub

'Excuted SQL. Useful for debugging and comparison
Public Property Get ConvertSQLExecuted() As String
   ConvertSQLExecuted = mstrConvertSQLExecuted
End Property

Friend Property Let ConvertSQLExecuted(ByVal strConvertSQLExecuted As String)
   mstrConvertSQLExecuted = strConvertSQLExecuted
End Property

'Excuted connect string. Useful for debugging and comparison
Public Property Get ConnectStringExecuted() As String
   ConnectStringExecuted = mstrConnectStringExecuted
End Property

Friend Property Let ConnectStringExecuted(ByVal strConnectStringExecuted As String)
   mstrConnectStringExecuted = strConnectStringExecuted
End Property

'Staus message handling. Raise OnStatusChange event in this module
Friend Function ShowStatus(Msg As CDBConvertStatusMsgEnum)
    Dim MsgText
    Select Case Msg
    Case CDBConvertStatusMsgEnum.[Conversion Initial Ready]
        MsgText = "Select the soruce and destination database files for conversion. "
    Case CDBConvertStatusMsgEnum.[Conversion Preparing Start]
        RaiseEvent OnStart("Start to prepare conversion.", Me.Source, Me.Destination)
        MsgText = "Start to prepare conversion."
   Case CDBConvertStatusMsgEnum.[Conversion Preparing Proceeding]
        MsgText = "Preparing conversion...."
    Case CDBConvertStatusMsgEnum.[Conversion Preparing End]
        MsgText = "Preparing conversion has been completed."
    Case CDBConvertStatusMsgEnum.[Conversion Start]
        MsgText = "Starts conversion"
    Case CDBConvertStatusMsgEnum.[Conversion Proceeding]
        MsgText = "Converting database data...."
    Case CDBConvertStatusMsgEnum.[Conversion Proceeding Connect to Source]
        MsgText = "Connecting to the source database."
    Case CDBConvertStatusMsgEnum.[Conversion Proceeding Write to Destination]
        MsgText = "Writing to the desitnation database."
    Case CDBConvertStatusMsgEnum.[Conversion Complete]
        MsgText = "Conversion has been completed."
        RaiseEvent OnComplete(MsgText, Me.Source, Me.Destination)
    Case CDBConvertStatusMsgEnum.[Conversion Preparing Error]
        MsgText = "A problem has occured during perpairing conversion."
    Case CDBConvertStatusMsgEnum.[Conversion Error]
        MsgText = "A problem has occured during conversion."
    Case Else
        MsgText = "Unknow error has occurred."
    End Select
    
    ShowStatus = MsgText
    RaiseEvent OnStatusChange(MsgText, Msg)
End Function

'Allows the user to turn off the operation success message display.
Public Property Get SuccessMsgBoxEnabled() As Boolean
   SuccessMsgBoxEnabled = mboolSuccessMsgBoxEnabled
End Property

Public Property Let SuccessMsgBoxEnabled(ByVal boolSuccessMsgBoxEnabled As Boolean)
   mboolSuccessMsgBoxEnabled = boolSuccessMsgBoxEnabled
End Property

'Allows the user to turn off error msgbox display.
Public Property Get ErrorMsgBoxEnabled() As Boolean
   ErrorMsgBoxEnabled = mboolErrorMsgBoxEnabled
End Property

Public Property Let ErrorMsgBoxEnabled(ByVal boolErrorMsgBoxEnabled As Boolean)
   mboolErrorMsgBoxEnabled = boolErrorMsgBoxEnabled
End Property

'Show messages using this procedure
Private Sub ShowMsg(strMsg, Title, Msg As CDBConvertStatusMsgEnum)
    Me.MsgDetail = strMsg
    Call ShowStatus(Msg)
    If Me.SuccessMsgBoxEnabled Then
        VBA.MsgBox strMsg, vbInformation, Title
    End If
End Sub

'Allows the user to get the detailed description of a mesage
'because the message to be shown on the statusbar
'is comparatively short.
Public Property Get MsgDetail() As String
   MsgDetail = mstrMsgDetail
End Property

Friend Property Let MsgDetail(ByVal strMsgDetail As String)
   mstrMsgDetail = strMsgDetail
End Property

'Show error messages using this procedure
Private Sub ShowError(strMsg, Title, Msg As CDBConvertStatusMsgEnum)
    Me.ErrorDetail = strMsg
    Call ShowStatus(Msg)
    RaiseEvent OnError(strMsg)
    If Me.ErrorMsgBoxEnabled Then
        VBA.MsgBox strMsg, vbExclamation, Title
    End If
End Sub

'Allows the user to get the detailed description of an error mesage
'because the message to be shown on the statusbar
'is comparatively short.
Public Property Get ErrorDetail() As String
   ErrorDetail = mstrErrorDetail
End Property

Friend Property Let ErrorDetail(ByVal strErrorDetail As String)
   mstrErrorDetail = strErrorDetail
End Property

'Hook combo boxes for table name loading
'You can initailly hook them.
Public Function HookTableComboBoxes( _
    cboSourceCombo As VB.ComboBox, cboDestinatonCombo As VB.ComboBox) As Long
    Set mcboSourceCombo = cboSourceCombo
    Set mcboDestinationCombo = cboDestinatonCombo
End Function

'Convert database from source to destionation
Public Function ConvertDatabaseEx( _
    SourceFile As String, DestinationFile As String, _
    Optional SoureFileTable As String, _
    Optional DestinationFileTable As String, _
    Optional retError As Long)

    Dim strMsg As String
    
    ShowStatus [Conversion Preparing Start]

    retError = 0
    'Set the source & desitnation full names
    Me.Source = SourceFile
    Me.Destination = DestinationFile
    'Set the source/destination table. Only some formats requires tables.
    Me.SourceTable = IIf(Me.SourceTableRequired, SoureFileTable, "")
    Me.DestinationTable = IIf(Me.DestinationTableRequired, DestinationFileTable, "")
    
    
    ShowStatus [Conversion Preparing Proceeding]
    
    'Validate source database's  file paths
    If Not ValidateSourceDatabase Then
        retError = -1: GoTo ExitProc
    End If
    
    'certain DB formats require a table name
    If Me.SourceFormat = [Access 2000] Or Me.SourceFormat = [Excel 2000] Then
        If Len(Trim$(Me.SourceTable)) = 0 Then
            strMsg = "The source table is not specfied. Select a table and retry." & _
                        vbCrLf & "[" & Me.Source & "]"
            ShowError strMsg, "Convert Database Data", [Conversion Preparing Error]
            retError = -1: GoTo ExitProc
        End If
    End If
    
    'Validate destination database
    If Not ValidateDestinationDatabase Then
        retError = -1: GoTo ExitProc
    End If

    'verify that table/file name is valid
    If Not CheckDestinationTable(retError) Then
        retError = -1: GoTo ExitProc
    End If

    ShowStatus [Conversion Preparing End]
    
    ShowStatus [Conversion Start]
    
    'convert the database
    If Not ConvertDatabase(retError) Then
        retError = -1: GoTo ExitProc
    End If
    
    
    'show the success message
    strMsg = "Conversion complete!" & _
                    vbCrLf & vbCrLf & "Source Database: " & Me.Source
    If Me.SourceTableRequired Then
        strMsg = strMsg & vbCrLf & "Source Table: " & Me.SourceTable
    End If
    strMsg = strMsg & vbCrLf & "Destination Database: " & Me.Destination
    If Me.DestinationTableRequired Then
        strMsg = strMsg & vbCrLf & "Destination Table: " & Me.DestinationTable
    End If
    ShowMsg strMsg, "Convert Database Data", [Conversion Complete]

ExitProc:
    Exit Function
End Function

'Executes actual ADO conversion code
Public Function ConvertDatabase( _
    retError As Long) As Boolean
    
    'convert one database format to another with a table or stored query
    
    On Error GoTo ErrHandle
     
    ShowStatus [Conversion Proceeding]
    
    Dim cnn As New ADODB.Connection
    Dim strMsg As String
    
    Screen.MousePointer = vbHourglass
    
    'Get the conenction string necessary to conenct the source.
    'SourceConnectionString property is used.
    Me.ConnectStringExecuted = Me.SourceConnectionString(retError)
    If retError < 0 Then
        Me.ConvertSQLExecuted = "[Connect String Failed]"
        GoTo ExitProc
    End If
        
    'Open the conenction using the obtained connection string
    ShowStatus [Conversion Proceeding Connect to Source]
    cnn.Open Me.ConnectStringExecuted
    
    'Get the SQL for conversion
    'SQLConvertString is used to get the SQL.
    ShowStatus [Conversion Proceeding Write to Destination]
    Me.ConvertSQLExecuted = Me.SQLConvertString
    
    'Execute conversion with ADO
    cnn.Execute Me.ConvertSQLExecuted
    
    'If successful, close the connection
    If cnn.State <> adStateClosed Then
        cnn.Close
    End If
    
    'This is nessary to work around a bug with ADO.
    'When the converted format is 'Text', some file name cannot be used.
    'Especially, the basename of the source is equal to that of the destination,
    'you will get an error message form JET database
    If Me.DestinationFormat = [Text File] Then
        If Me.DestinationBaseName = Me.SourceBaseName Then
            'Revert the tmp file
            If FileExist(Me.DestinationPath & "\" & Me.DestinationBaseName & "ttt-tmp-tmp-db.txt") Then
                Name Me.DestinationPath & "\" & Me.DestinationBaseName & "ttt-tmp-tmp-db.txt" As Me.Destination
            End If
        End If
    End If
    
    ShowStatus [Conversion Complete]
    ConvertDatabase = True
    retError = 0

ExitProc: 'Do clean up
    Screen.MousePointer = vbDefault
    If cnn.State <> adStateClosed Then
        cnn.Close
    End If
    Set cnn = Nothing
    Exit Function
ErrHandle:

    Screen.MousePointer = vbDefault
    'Still, you may get an error messae due to a bug of JET database.
    'I couldn't deterime the exact behavir of this kind of bug.
    'I cannot find a method to work around it. If you find, let me know. I'll really appreciate it.
    Select Case Err.Number
    Case -2147467259
        strMsg = "Due to a bug of JET database engine, cannot create the destinatin table or file." & _
             vbCrLf & "Please specifit other name and try again." & _
            vbCrLf & vbCrLf & Err.Description
        ShowError strMsg, "Convert Database Data", [Conversion Error]
    Case Else
        ShowError Err.Number & " " & Err.Source & vbCrLf & Err.Description, "Convert Database Data", [Conversion Error]
    End Select
    retError = -1
    Resume ExitProc
End Function


'Validate source database file paths
Private Function ValidateSourceDatabase() As Boolean
    
    Dim strMsg As String
    
    'make sure that the source file exists
    If Len(Me.Source) = 0 Then
        strMsg = "Please specify the source database file"
        ShowError strMsg, "Convert Database Data", [Conversion Preparing Error]
        Exit Function
    End If

    'make sure that the source file exists
    If Not FileExist(Me.Source) Then
        strMsg = "The specified source database file does not exist. Select a valid file." & _
                    vbCrLf & "[" & Me.Source & "]"
        ShowError strMsg, "Convert Database Data", [Conversion Preparing Error]
        Exit Function
    End If
    
    'make sure that the folder exists
'    If Not FolderExist(Me.SourcePath) Then
'        strMsg = "The folder of the specifed source database file does not exist. Select a valid file." & _
'                    vbCrLf & "[" & Me.Source & "]"
'        ShowError strMsg, "Convert Database Data", [Conversion Preparing Error]
'        Exit Function
'    End If
'
    'make sure that a format has been selected
    If Me.SourceFormat < [Access 2000] Or Me.SourceFormat > [Text File] Then
        strMsg = "Please specify the format of the source database." & _
                    vbCrLf & "[" & Me.Source & "]"
        ShowError strMsg, "Convert Database Data", [Conversion Preparing Error]
        Exit Function
    End If
    
    ValidateSourceDatabase = True
End Function

'Validate destination database file paths
Private Function ValidateDestinationDatabase() As Boolean
    
    Dim strMsg As String
    
    If Len(Me.Destination) = 0 Then
        strMsg = "Please specify the destination database file"
        ShowError strMsg, "Convert Database Data", [Conversion Preparing Error]
        Exit Function
    End If
        
     'make sure that the destination file exists in case of access db
          
    If (Not FileExist(Me.Destination)) And Me.DestinationFormat = [Access 2000] Then
        strMsg = "The specified destination database file does not exist. Select a valid file." & _
                    vbCrLf & "[" & Me.Destination & "]"
        ShowError strMsg, "Convert Database Data", [Conversion Preparing Error]
        Exit Function
    End If
    

    If Not FolderExist(Me.DestinationPath) Then
        strMsg = "The folder of the specifed destination database file does not exist. Select a valid file." & _
                    vbCrLf & "[" & Me.Destination & "]"
        ShowError strMsg, "Convert Database Data", [Conversion Preparing Error]
        Exit Function
    End If

    
    If Me.DestinationFormat < [Access 2000] Or Me.DestinationFormat > [Text File] Then
        strMsg = "Please specify the format of the destination database." & _
                    vbCrLf & "[" & Me.Destination & "]"
        ShowError strMsg, "Convert Database Data", [Conversion Preparing Error]
        Exit Function
    End If
    
    'certain DB formats require a table name
   If Me.DestinationFormat = [Access 2000] Or Me.DestinationFormat = [Excel 2000] Then
        If Len(Trim$(Me.DestinationTable)) = 0 Then
            strMsg = "Please select the format of the destination file." & _
                        vbCrLf & "[" & Me.Destination & "]"
            ShowError strMsg, "Convert Database Data", [Conversion Preparing Error]
            Exit Function
        End If
    End If

    ValidateDestinationDatabase = True
End Function

'Convert database from source to destionation
'the data to be converted are seleced with a SQL instead of a table or query.

Public Function ConvertDatabaseWithSQL( _
    SourceFile As String, DestinationFile As String, _
    SourceDataExtractionSQL As String, _
    Optional DestinationFileTable As String, _
    Optional retError As Long)
    
    Dim strMsg As String
    ShowStatus [Conversion Preparing Start]

    retError = 0
    
    'Set the source & desitnation full names
    Me.Source = SourceFile
    Me.Destination = DestinationFile
    
     'Set the destination table. Only some formats requires tables.
    Me.DestinationTable = IIf(Me.DestinationTableRequired, DestinationFileTable, "")
    
    ShowStatus [Conversion Preparing Proceeding]
    
     'Validate source database's  file paths
    If Not ValidateSourceDatabase Then
        retError = -1: GoTo ExitProc
    End If
    
    'check the sql is given
    If Len(Trim$(SourceDataExtractionSQL)) = 0 Then
        strMsg = "Please specify the SQL for extracting the data to be converted." & _
                    vbCrLf & "[" & Me.Source & "]"
        ShowError strMsg, "Convert Database Data", [Conversion Preparing Error]
        retError = -1: GoTo ExitProc
    End If
    
    'Validate destination database
    If Not ValidateDestinationDatabase Then
        retError = -1: GoTo ExitProc
    End If
    
    'verify that table/file name is valid
    If Not CheckDestinationTable(retError) Then
        retError = -1: GoTo ExitProc
    End If
    
    ShowStatus [Conversion Preparing End]
    
    ShowStatus [Conversion Start]
    
    'Extract and covert data
    If Not ConvertDatabaseWithSQLX(SourceDataExtractionSQL, retError) Then
        retError = -1: GoTo ExitProc
    End If
    
     'show the success message
    strMsg = "Conversion complete!" & _
                    vbCrLf & vbCrLf & "Source Database: " & Me.Source
    strMsg = strMsg & vbCrLf & "Destination Database: " & Me.Destination
    If Me.DestinationTableRequired Then
        strMsg = strMsg & vbCrLf & "Destination Table: " & Me.DestinationTable
    End If
    strMsg = strMsg & vbCrLf & "SQL: " & vbCrLf & Me.ConvertSQLExecuted
    
    ShowMsg strMsg, "Convert Database Data", [Conversion Complete]

ExitProc:
    Exit Function
    
End Function

'Executes actual ADO conversion code
'Data to convert are extracted with a SQL, which is used as a subquery.
Public Function ConvertDatabaseWithSQLX( _
    ByVal SQL As String, _
    Optional retError As Long) As Boolean

    'convert one database format to another with the data extracted with a SQL

    On Error GoTo ErrHandle

    ShowStatus [Conversion Proceeding]
    
    Dim cnn As New ADODB.Connection
    Dim strMsg As String
    Dim strSQL As String

    Screen.MousePointer = vbHourglass
    
    'Get the conenction string necessary to conenct the source.
    'SourceConnectionString property is used.
    Me.ConnectStringExecuted = Me.SourceConnectionString(retError)
    If retError < 0 Then
        Me.ConvertSQLExecuted = "[Connect String Failed]"
        GoTo ExitProc
    End If
    
    'Get the SQL for conversion. 2 steps are requried.
    '1. Get the first part of INSERT SQL using the SQLConvertString property
    Me.ConvertSQLExecuted = Me.SQLConvertString
    Dim pos As Long
    pos = InStr(1, Me.ConvertSQLExecuted, "FROM")
    If pos < 1 Then
        ShowStatus [Conversion Error]
        GoTo ExitProc
    End If
    'Remove uncessary part.
    Me.ConvertSQLExecuted = Left$(Me.ConvertSQLExecuted, pos - 1)
    'Remove ";" because SQL subquery syntax does not allow it to to be used.
    SQL = Replace(Replace(SQL, ";", ""), vbCrLf, " ")
    
    '2. Combine the first part of INSERT query with the SQL that the user has input.
    Me.ConvertSQLExecuted = Me.ConvertSQLExecuted & "FROM (" & SQL & ");"
    'EXAMPLE:
    'Me.ConvertSQLExecuted = "SELECT * INTO [text1.csv] IN 'D:\MyDoc' 'Text;' " & _
                           "FROM (SELECT DISTINCT * FROM Table1, Table2 WHERE Table1.ID = Table2.ID);"
    
    'Open the conenction using the obtained connection string
    ShowStatus [Conversion Proceeding Connect to Source]
    cnn.Open Me.ConnectStringExecuted
    
    'Execute conversion with ADO
    ShowStatus [Conversion Proceeding Write to Destination]
    cnn.Execute Me.ConvertSQLExecuted
    
    'If successful, close the connection
    If cnn.State <> adStateClosed Then
        cnn.Close
    End If
    
    
    'This is nessary to work around a bug with ADO.
    'When the converted format is 'Text', some file name cannot be used.
    'Especially, the basename of the source is equal to that of the destination,
    'you will get an error message form JET database
    If Me.DestinationFormat = [Text File] Then
        If Me.DestinationBaseName = Me.SourceBaseName Then
            'Revert the tmp file
            If FileExist(Me.DestinationPath & "\" & Me.DestinationBaseName & "ttt-tmp-tmp-db.txt") Then
                Name Me.DestinationPath & "\" & Me.DestinationBaseName & "ttt-tmp-tmp-db.txt" As Me.Destination
            End If
        End If
    End If
    
    ShowStatus [Conversion Complete]
    ConvertDatabaseWithSQLX = True
    retError = 0

ExitProc: 'Do clean up
    Screen.MousePointer = vbDefault
    If cnn.State <> adStateClosed Then
        cnn.Close
    End If
    Set cnn = Nothing
    Exit Function
    
ErrHandle:
    Screen.MousePointer = vbDefault
    'Still, you may get an error messae due to a bug of JET database.
    'I couldn't deterime the exact behavir of this kind of bug.
    'I cannot find a method to work around it. If you find, let me know. I'll really appreciate it.
    Select Case Err.Number
    Case -2147467259
        strMsg = "Due to a bug of JET database engine, cannot create the destinatin table or file." & _
             vbCrLf & "Please specifit other name and try again." & _
            vbCrLf & vbCrLf & Err.Description
        ShowError strMsg, "Convert Database Data", [Conversion Error]
    Case Else
        ShowError Err.Number & " " & Err.Source & vbCrLf & Err.Description, "Convert Database Data", [Conversion Error]
    End Select
    retError = -1
    Resume ExitProc
End Function


'verify that file and/or table does not already exist
'prompt user for how to handle existing files/tables
Function CheckDestinationTable(retError As Long) As Boolean

    On Error GoTo ErrHandle

    Dim i As Integer
    Dim cat As New adox.Catalog
    Dim strMsg As String
    Dim strConn As String

    If Len(Trim$(Me.Destination)) = 0 Then
        retError = -1
        GoTo ExitProc
    End If
    
    If FileExist(Me.Destination) = True Then
        Select Case Me.DestinationFormat
        Case [Access 2000], [Excel 2000]  'Certain databases may have existing tables
            If (Me.DestinationFormat = [Access 2000]) Then 'Access DB
                strConn = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" & Me.Destination & ";" & _
                                "Jet OLEDB:Engine Type=4;"
            Else 'Excel files
                strConn = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" & Me.Destination & ";" & _
                                "Extended Properties=Excel 8.0;"
            End If
            
            'set the catalog connection
            cat.ActiveConnection = strConn
            
            For i = 0 To cat.Tables.Count - 1
                If Trim$(UCase(cat.Tables(i).Name)) = Trim$(UCase(Me.DestinationTable)) Then
                    strMsg = "Table [" & Me.DestinationTable & "] already exists in the file " & _
                        "[" & Me.Destination & "]. If you continue, the table will be OVERWRITTEN. " & _
                         vbCrLf & vbCrLf & "Are you sure to continue?"
                    If MsgBox(strMsg, vbQuestion + vbYesNo, "Table Overwriting") = vbNo Then
                        GoTo ExitProc
                    Else 'delete the table
                        cat.Tables.Delete i
                        Exit For
                    End If
                End If
            Next i
            
        Case Else 'Verify that file does not already exist
            strMsg = "The file [" & Me.Destination & "] already exists. If you continue, the file will be OVERWRITTEN. " & _
                            vbCrLf & vbCrLf & "Are you sure to continue?"
            If MsgBox(strMsg, vbQuestion + vbYesNo, "File Overwriting") = vbNo Then
                GoTo ExitProc
            Else 'delete the file
                Kill Me.Destination
            End If
        End Select
    End If
    
    CheckDestinationTable = True
    
ExitProc: 'Do clean up
    Set cat = Nothing
    Exit Function

ErrHandle:
    ShowError Err.Number & " " & Err.Source & vbCrLf & Err.Description, "Convert Database Data", [Conversion Error]
    retError = -1
    Resume ExitProc
End Function


'return the ADO connection string for connecting to the source database
Public Property Get SourceConnectionString(Optional retError As Long) As String

    Dim strMsg As String
    retError = 0 'No Error
    
    'Check the source is valid
    If Not FileExist(Me.Source) Then
        strMsg = "The source database file does not exists. Cannot conenct to the database." & vbCrLf & _
                      "[" & Me.Source & "]" & vbCrLf & vbCrLf & _
                        "Select a valid source database file."
        ShowError strMsg, "Convert Database Data", [Conversion Preparing Error]
        retError = -1
        GoTo ExitProc
    End If
    
    Select Case Me.SourceFormat
    Case CDBConvertDBFormatEnum.[Access 2000] 'Access 2000
        SourceConnectionString = "Provider=" & _
            "Microsoft.Jet.OLEDB.4.0;" & _
            "Data Source=" & Me.Source & ";" & _
            "Jet OLEDB:Engine Type=4;"
            
    Case CDBConvertDBFormatEnum.[dBase III] 'dBase III
        SourceConnectionString = "Provider=MSDASQL.1;" & _
            "Extended Properties=;DRIVER=" & _
            "Microsoft dBase Driver (*.dbf);" & _
            "DefaultDir=" & Me.SourcePath & ";DriverId=21;" & _
            "FIL=dBase III;MaxBufferSize=2048;" & _
            "PageTimeout=600;UID=admin;"
            
    Case CDBConvertDBFormatEnum.[dBase IV] 'dBase IV
        SourceConnectionString = "Provider=MSDASQL.1;" & _
            "Extended Properties=;DRIVER=" & _
            "Microsoft dBase Driver (*.dbf);" & _
            "DefaultDir=" & Me.SourcePath & ";DriverId=21;" & _
            "FIL=dBase IV;MaxBufferSize=2048;" & _
            "PageTimeout=600;UID=admin;"
            
    Case CDBConvertDBFormatEnum.[dBase V] 'dBase V
        SourceConnectionString = "Provider=MSDASQL.1;" & _
            "Extended Properties=;DRIVER=" & _
            "Microsoft dBase Driver (*.dbf);" & _
            "DefaultDir=" & Me.SourcePath & ";DriverId=21;" & _
            "FIL=dBase V;MaxBufferSize=2048;" & _
            "PageTimeout=600;UID=admin;"
            
    Case CDBConvertDBFormatEnum.[Excel 2000] 'Excel 2000
        SourceConnectionString = "Provider=" & _
            "Microsoft.Jet.OLEDB.4.0;" & _
            "Data Source=" & Me.Source & ";" & _
            "Extended Properties=Excel 8.0;"

    Case CDBConvertDBFormatEnum.[Html Document] 'HTML
        SourceConnectionString = "Provider=" & _
            "Microsoft.Jet.OLEDB.4.0;" & _
            "Data Source=" & Me.Source & ";" & _
            "Extended Properties=HTML Import;"
            
    Case CDBConvertDBFormatEnum.[Text File], CDBConvertDBFormatEnum.[CSV File]  'Text & CSV
        SourceConnectionString = "Driver={Microsoft Text Driver " & _
            "(*.txt; *.csv)};DBQ=" & Me.SourcePath & _
            ";DefaultDir=" & Me.SourcePath & ";Uid=Admin;Pwd=;"

    Case Else
        retError = -1
    End Select

ExitProc:
End Property

'Load source table/query names to como boxes
Public Function LoadSourceTables(cboCombo As VB.ComboBox, _
    Optional retTableCount As Long, Optional retError As Long) As Variant
    
    Set mcboSourceCombo = cboCombo
    LoadSourceTables = GetSourceTables(retTableCount, retError)
End Function

'Load source table names to hooked combo boxes
'and returns the array of table/query names
Public Function GetSourceTables( _
    retTableCount As Long, _
    retError As Long) As Variant

    On Error GoTo ErrHandle
    
    Dim i As Integer
    Dim cat As New adox.Catalog
    Dim strMsg As String
    Dim strConn As String
    Dim strTables() As String

    'initialize table count
    retTableCount = 0
    
    'only process when the table is required
    If Not Me.SourceTableRequired Then
        If Not mcboSourceCombo Is Nothing Then
            mcboSourceCombo.Enabled = False
            GoTo ExitProc
        End If
    Else
        mcboSourceCombo.Enabled = True
    End If
    
    'load the tables for an Access DB or Excel Spreadsheet
    If Trim$(Me.Source) = "" Then
        strMsg = "The source database file is not specfied. Cannot load table & query names." & vbCrLf & _
                    "Select a valid source database file."
        ShowError strMsg, "Convert Database Data", [Conversion Preparing Error]
        retError = -1
        GoTo ExitProc
    End If
    
    If Not FileExist(Me.Source) Then
        If Me.SourceFormat = [Access 2000] Then 'Access DB
            strMsg = "The specified source database file does not exist. Cannot load table & query names." & vbCrLf & _
                          "[" & Me.Source & "]" & vbCrLf & vbCrLf & _
                            "Select a valid source database file."
            ShowError strMsg, "Convert Database Data", [Conversion Preparing Error]
        End If
        retError = -1
        GoTo ExitProc
    End If
    
    If Me.SourceFormat = [Access 2000] Then 'Access DB
        strConn = "Provider=Microsoft.Jet.OLEDB.4.0;" & _
            "Data Source=" & Me.Source & ";" & _
            "Jet OLEDB:Engine Type=4;"
    ElseIf Me.SourceFormat = [Excel 2000] Then 'Excel Spreadsheet
        strConn = "Provider=" & _
            "Microsoft.Jet.OLEDB.4.0;" & _
            "Data Source=" & Me.Source & ";" & _
            "Extended Properties=Excel 8.0;"
    End If
    
    'open a catalog connection to the database
     cat.ActiveConnection = strConn
     
     retTableCount = cat.Tables.Count
     ReDim strTables(retTableCount - 1)
     
     'return the table names
     If Not mcboSourceCombo Is Nothing Then
         mcboSourceCombo.Clear
     End If
     For i = 0 To retTableCount - 1
         strTables(i) = Trim$(cat.Tables(i).Name)
         If Not mcboSourceCombo Is Nothing Then
             mcboSourceCombo.AddItem Trim$(cat.Tables(i).Name)
         End If
     Next i
     
     GetSourceTables = strTables
     retError = 0
    
ExitProc: 'Do clean up
    Set cat = Nothing
    Exit Function


ErrHandle:
    ShowError Err.Number & " " & Err.Source & vbCrLf & Err.Description, "Convert Database Data", [Conversion Error]
    retError = -1
    Resume ExitProc
End Function


'Load destination table/query names to como boxes
Public Function LoadDestinationTables(cboCombo As VB.ComboBox, _
    Optional retTableCount As Long, Optional retError As Long) As Variant
    
    Set mcboDestinationCombo = cboCombo
    LoadDestinationTables = GetDestinationTables(retTableCount, retError)
End Function

'Load desination table names to hooked combo boxes
'and returns the array of table/query names
Public Function GetDestinationTables( _
    retTableCount As Long, _
    retError As Long) As Variant
    
    On Error GoTo ErrHandle

    Dim i As Integer
    Dim cat As New adox.Catalog
    Dim strMsg As String
    Dim strConn As String
    Dim strTables() As String

    'initialize table count
    retTableCount = 0
    
    'only process when the table is required
    If Not Me.DestinationTableRequired Then
        If Not mcboDestinationCombo Is Nothing Then
            mcboDestinationCombo.Enabled = False
            GoTo ExitProc
        End If
    Else
        mcboDestinationCombo.Enabled = True
    End If
    
    'load the tables for an Access DB or Excel Spreadsheet
    If Trim$(Me.Destination) = "" Then
        strMsg = "The destination database file is not specfied. Cannot load table & query names." & vbCrLf & _
                    "Select a valid destination database file."
        ShowError strMsg, "Convert Database Data", [Conversion Preparing Error]
        retError = -1
        GoTo ExitProc
    End If
    
    If Not FileExist(Me.Destination) Then
        If Me.DestinationFormat = [Access 2000] Then 'Access DB
            strMsg = "The specified destination database file does not exist. Cannot load table & query names." & vbCrLf & _
                          "[" & Me.Source & "]" & vbCrLf & vbCrLf & _
                            "Select a valid destination database file."
            ShowError strMsg, "Convert Database Data", [Conversion Preparing Error]
        End If
        retError = -1
        GoTo ExitProc
    End If
    
    If Me.DestinationFormat = [Access 2000] Then 'Access DB
        strConn = "Provider=Microsoft.Jet.OLEDB.4.0;" & _
            "Data Source=" & Me.Destination & ";" & _
            "Jet OLEDB:Engine Type=4;"
    ElseIf Me.DestinationFormat = [Excel 2000] Then 'Excel Spreadsheet
        strConn = "Provider=" & _
            "Microsoft.Jet.OLEDB.4.0;" & _
            "Data Source=" & Me.Destination & ";" & _
            "Extended Properties=Excel 8.0;"
    End If

    'open a catalog connection to the database
    cat.ActiveConnection = strConn
    
    retTableCount = cat.Tables.Count
    ReDim strTables(retTableCount - 1)
    
    'return the table names
    If Not mcboDestinationCombo Is Nothing Then
        mcboDestinationCombo.Clear
    End If
    For i = 0 To retTableCount - 1
        strTables(i) = Trim$(cat.Tables(i).Name)
        If Not mcboDestinationCombo Is Nothing Then
            mcboDestinationCombo.AddItem Trim$(cat.Tables(i).Name)
        End If
    Next i
    
    GetDestinationTables = strTables
    retError = 0
    
ExitProc: 'Do clean up
    Set cat = Nothing
    Exit Function



ErrHandle:
    ShowError Err.Number & " " & Err.Source & vbCrLf & Err.Description, "Convert Database Data", [Conversion Error]
    retError = -1
    Resume ExitProc
End Function

'return the SQL string for the passed criteria
'this will be used with the ADO connection string
Property Get SQLConvertString() As String

    Dim strPath As String
    Dim strBase As String
    Dim strFile As String
    Dim strSQL As String
    Dim strTable As String
    Dim strFromTable As String
    
    strPath = Me.DestinationPath
    strBase = Me.DestinationBaseName
    strFile = Me.DestinationFileName
    strTable = Me.DestinationTable
    strFromTable = Me.SourceTable
    
    strSQL = "SELECT * INTO "
    
    Select Case Me.DestinationFormat
    
    Case CDBConvertDBFormatEnum.[Access 2000] 'Access 2000
            strSQL = strSQL & "[" & strTable & _
                "] IN '" & Me.Destination & "'"
                
    Case CDBConvertDBFormatEnum.[dBase III] 'dBase III
            strSQL = strSQL & "[" & strBase & _
                "] IN '" & strPath & "' 'dBase III;'"
    
    Case CDBConvertDBFormatEnum.[dBase IV] 'dBase IV
            strSQL = strSQL & "[" & strBase & _
                "] IN '" & strPath & "' 'dBase IV;'"
    
    Case CDBConvertDBFormatEnum.[dBase V] 'dBase V
            strSQL = strSQL & "[" & strBase & _
                "] IN '" & strPath & "' 'dBase 5.0;'"
    
    Case CDBConvertDBFormatEnum.[Excel 2000] 'Excel 2000
            strSQL = strSQL & "[" & strTable & _
                "] IN '" & Me.Destination & "' 'Excel 8.0;'"
    
    Case CDBConvertDBFormatEnum.[Html Document] 'HTML
            strSQL = strSQL & "[" & strFile & _
                "] IN '" & strPath & "' 'HTML Export;'"
    
    Case CDBConvertDBFormatEnum.[Text File] 'Text
            'the following is necessary
            'to work around a bug with JET database engine
            If strBase = Me.SourceBaseName Then
                If FileExist(Me.DestinationPath & "\" & Me.DestinationBaseName & "ttt-tmp-tmp-db.txt") Then
                    Kill Me.DestinationPath & "\" & Me.DestinationBaseName & "ttt-tmp-tmp-db.txt"
                End If
                strFile = Me.DestinationBaseName & "ttt-tmp-tmp-db.txt"
'                'Debug.Print GetBaseName(strFile)
'                'Debug.Print GetBaseName(Me.SourceFileName)
            End If
            strSQL = strSQL & "[" & strFile & _
                "] IN '" & strPath & "' 'Text;'"
                
    Case CDBConvertDBFormatEnum.[CSV File]  'CSV
            'Actuallay CSV is same with Text.
            'Only file extension will be different.
            strSQL = strSQL & "[" & strFile & _
                "] IN '" & strPath & "' 'Text;'"
    End Select
    
    SQLConvertString = strSQL & " FROM " & strFromTable

End Property


'-------------------------------------------------------------------------------
' COMMENT: Public Properties
'-------------------------------------------------------------------------------
'Source database file
Public Property Get Source() As String
   Source = mstrSource
End Property

Public Property Let Source(ByVal strSource As String)
   mstrSource = strSource
   'determine the source format when the source file changes.
   Me.SourceFormat = GetFormat(mstrSource)
End Property

'Source databse format
Public Property Get SourceFormat() As CDBConvertDBFormatEnum
   SourceFormat = mlngSourceFormat
End Property

Friend Property Let SourceFormat(ByVal lngSourceFormat As CDBConvertDBFormatEnum)
   mlngSourceFormat = lngSourceFormat
End Property

'Source paths & extension
Public Property Get SourcePath() As String
   SourcePath = GetPathName(Me.Source)
End Property

Public Property Get SourceBaseName() As String
   SourceBaseName = GetBaseName(Me.Source)
End Property

Public Property Get SourceFileName() As String
   SourceFileName = GetFileName(Me.Source)
End Property

Public Property Get SourceExtension() As String
    Select Case Me.SourceFormat
    Case CDBConvertDBFormatEnum.[Access 2000] 'Access 2000
        SourceExtension = "mdb"
    Case CDBConvertDBFormatEnum.[dBase III] 'dBase III
        SourceExtension = "dbf"
    Case CDBConvertDBFormatEnum.[dBase IV] 'dBase IV
        SourceExtension = "dbf"
    Case CDBConvertDBFormatEnum.[dBase V] 'dBase V
        SourceExtension = "dbf"
    Case CDBConvertDBFormatEnum.[Excel 2000] 'Excel 2000
        SourceExtension = "xls"
    Case CDBConvertDBFormatEnum.[Html Document] 'HTML
        SourceExtension = "html"
    Case CDBConvertDBFormatEnum.[CSV File] 'CSV
        SourceExtension = "csv"
    Case CDBConvertDBFormatEnum.[Text File]  'Text
        SourceExtension = "txt"
    End Select
End Property

'set the selected soruce table to be converted
Public Property Get SourceTable() As String
   SourceTable = mstrSourceTable
End Property

Public Property Let SourceTable(ByVal strSourceTable As String)
    If Len(strSourceTable) = 0 Then
        mstrSourceTable = ""
        Exit Property
    End If
    
    Select Case Me.SourceFormat
    Case CDBConvertDBFormatEnum.[Access 2000] 'Access 2000
        mstrSourceTable = "[" & strSourceTable & "]"
    Case CDBConvertDBFormatEnum.[dBase III] 'dBase III
        mstrSourceTable = "[" & Me.SourceBaseName & "]"
    Case CDBConvertDBFormatEnum.[dBase IV] 'dBase IV
        mstrSourceTable = "[" & Me.SourceBaseName & "]"
    Case CDBConvertDBFormatEnum.[dBase V] 'dBase V
        mstrSourceTable = "[" & Me.SourceBaseName & "]"
    Case CDBConvertDBFormatEnum.[Excel 2000] 'Excel 2000
        mstrSourceTable = "[" & strSourceTable & "]"
    Case CDBConvertDBFormatEnum.[Html Document] 'HTML
        mstrSourceTable = "[" & Me.SourceBaseName & "]"
    Case CDBConvertDBFormatEnum.[CSV File], CDBConvertDBFormatEnum.[Text File]  'Text
        mstrSourceTable = "[" & Me.SourceFileName & "]"
    End Select
End Property

'Determines whether the source requires a table
Public Property Get SourceTableRequired() As Boolean
    Select Case Me.SourceFormat
    Case [Access 2000], [Excel 2000]  'Access 2000 & Excel 2000
        SourceTableRequired = True
    End Select
End Property

'Destination database file
Public Property Get Destination() As String
   Destination = mstrDestination
End Property

Public Property Let Destination(ByVal strDestination As String)
   mstrDestination = strDestination
   'determine the source format when the detinatioin file changes.
   Me.DestinationFormat = GetFormat(strDestination)
End Property

'Destination databse format
Public Property Get DestinationFormat() As CDBConvertDBFormatEnum
   DestinationFormat = mlngDestinationFormat
End Property

Friend Property Let DestinationFormat(ByVal lngDestinationFormat As CDBConvertDBFormatEnum)
   mlngDestinationFormat = lngDestinationFormat
End Property

'Destination paths & extension
Public Property Get DestinationPath() As String
   DestinationPath = GetPathName(Me.Destination)
End Property

Public Property Get DestinationBaseName() As String
   DestinationBaseName = GetBaseName(Me.Destination)
End Property

Public Property Get DestinationFileName() As String
   DestinationFileName = GetFileName(Me.Destination)
End Property

Public Property Get DestinationExtension() As String
    Select Case Me.DestinationFormat
    Case CDBConvertDBFormatEnum.[Access 2000] 'Access 2000
        DestinationExtension = "mdb"
    Case CDBConvertDBFormatEnum.[dBase III] 'dBase III
        DestinationExtension = "dbf"
    Case CDBConvertDBFormatEnum.[dBase IV] 'dBase IV
        DestinationExtension = "dbf"
    Case CDBConvertDBFormatEnum.[dBase V] 'dBase V
        DestinationExtension = "dbf"
    Case CDBConvertDBFormatEnum.[Excel 2000] 'Excel 2000
        DestinationExtension = "xls"
    Case CDBConvertDBFormatEnum.[Html Document] 'HTML
        DestinationExtension = "html"
    Case CDBConvertDBFormatEnum.[CSV File] 'CSV
        DestinationExtension = "csv"
    Case CDBConvertDBFormatEnum.[Text File]  'Text
        DestinationExtension = "txt"
    End Select
End Property

'set the selected destination table where new records are inserted.
Public Property Get DestinationTable() As String
   DestinationTable = mstrDestinationTable
End Property

Public Property Let DestinationTable(ByVal strDestinationTable As String)
    If Len(strDestinationTable) = 0 Then
        mstrDestinationTable = ""
        Exit Property
    End If
    
    Select Case Me.DestinationFormat
    Case CDBConvertDBFormatEnum.[Access 2000] 'Access 2000
        mstrDestinationTable = "[" & strDestinationTable & "]"
    Case CDBConvertDBFormatEnum.[dBase III] 'dBase III
        mstrDestinationTable = "[" & Me.DestinationBaseName & "]"
    Case CDBConvertDBFormatEnum.[dBase IV] 'dBase IV
        mstrDestinationTable = "[" & Me.DestinationBaseName & "]"
    Case CDBConvertDBFormatEnum.[dBase V] 'dBase V
        mstrDestinationTable = "[" & Me.DestinationBaseName & "]"
    Case CDBConvertDBFormatEnum.[Excel 2000] 'Excel 2000
        mstrDestinationTable = "[" & strDestinationTable & "]"
    Case CDBConvertDBFormatEnum.[Html Document] 'HTML
        mstrDestinationTable = "[" & Me.DestinationBaseName & "]"
    Case CDBConvertDBFormatEnum.[CSV File], CDBConvertDBFormatEnum.[Text File]  'Text
        mstrDestinationTable = "[" & Me.DestinationFileName & "]"
    End Select
End Property

Public Property Get DestinationTableRequired() As Boolean
    Select Case Me.DestinationFormat
    Case [Access 2000], [Excel 2000]  'Access 2000 & Excel 2000
        DestinationTableRequired = True
    End Select
End Property

'-------------------------------------------------------------------------------
' Public Utilities
'-------------------------------------------------------------------------------
'Load the database formats for them this class support conversion to combo boxes
Public Sub LoadAvailableDatabaseFormats(cboFromatCombo As VB.ComboBox)

    On Error GoTo Ooops
    
    With cboFromatCombo
        .Clear
        .AddItem "Access 2000"
        .ItemData(.NewIndex) = CDBConvertDBFormatEnum.[Access 2000]
        
        .AddItem "CSV"
        .ItemData(.NewIndex) = CDBConvertDBFormatEnum.[CSV File]
        
        .AddItem "dBase III"
        .ItemData(.NewIndex) = CDBConvertDBFormatEnum.[dBase III]
        
        .AddItem "dBase IV"
        .ItemData(.NewIndex) = CDBConvertDBFormatEnum.[dBase IV]
        
        .AddItem "dBase V"
        .ItemData(.NewIndex) = CDBConvertDBFormatEnum.[dBase V]
        
        .AddItem "Excel 2000"
        .ItemData(.NewIndex) = CDBConvertDBFormatEnum.[Excel 2000]
        
        .AddItem "HTML"
        .ItemData(.NewIndex) = CDBConvertDBFormatEnum.[Html Document]
        
        .AddItem "ASCII Text"
        .ItemData(.NewIndex) = CDBConvertDBFormatEnum.[Text File]
    End With

Ooops:
End Sub

'Retrun the file format on the file extension
Public Function GetFormat(strFileName As String, _
    Optional retError As Long) As CDBConvertDBFormatEnum

    On Error GoTo Ooops
    retError = 0
    
    Select Case Right(Trim$(UCase(strFileName)), 3)
    Case "MDB": GetFormat = [Access 2000]
    Case "DBF": GetFormat = [dBase III]
    Case "XLS": GetFormat = [Excel 2000]
    Case "HTM": GetFormat = [Html Document]
    Case "TXT": GetFormat = [Text File]
    Case "CSV": GetFormat = [CSV File]
    Case "TML"
        If Right(Trim$(UCase(strFileName)), 4) = "HTML" Then
            GetFormat = [Html Document]
        Else
            GoTo Ooops
        End If
    Case Else: GetFormat = -1 'GoTo Ooops
        
    End Select
    
    Exit Function
Ooops:
    Dim strMsg As String
    strMsg = "Unsupported file format!" & vbCrLf & "[" & strFileName & "]"
    retError = -1
End Function

'Returns the extension string on file format
Public Function GetExtension(DatabaseFormat As CDBConvertDBFormatEnum) As String
    Select Case DatabaseFormat
    Case CDBConvertDBFormatEnum.[Access 2000] 'Access 2000
        GetExtension = "mdb"
    Case CDBConvertDBFormatEnum.[dBase III] 'dBase III
        GetExtension = "dbf"
    Case CDBConvertDBFormatEnum.[dBase IV] 'dBase IV
        GetExtension = "dbf"
    Case CDBConvertDBFormatEnum.[dBase V] 'dBase V
        GetExtension = "dbf"
    Case CDBConvertDBFormatEnum.[Excel 2000] 'Excel 2000
        GetExtension = "xls"
    Case CDBConvertDBFormatEnum.[Html Document] 'HTML
        GetExtension = "html"
    Case CDBConvertDBFormatEnum.[CSV File] 'CSV
        GetExtension = "csv"
    Case CDBConvertDBFormatEnum.[Text File]  'Text
        GetExtension = "txt"
    End Select
End Function

'-------------------------------------------------------------------------------
' Private functions for gettting file name info
'-------------------------------------------------------------------------------
Private Function GetPathName(strFile As String) As String
    'return the path for a file (folder only)
    On Error GoTo Ooops
    Dim fso
    Set fso = CreateObject("Scripting.FileSystemObject")
    GetPathName = fso.GetParentFolderName(strFile)
Ooops:
    Set fso = Nothing
End Function

Private Function GetBaseName(strFile As String) As String
    'return the base filename (minus extension) for a folder
    On Error GoTo Ooops
    Dim fso
    Set fso = CreateObject("Scripting.FileSystemObject")
    GetBaseName = fso.GetBaseName(strFile)
Ooops:
    Set fso = Nothing
End Function

Private Function GetFileName(strFile As String) As String
    On Error GoTo Ooops
    'return the file for a folder
    Dim fso
    Set fso = CreateObject("Scripting.FileSystemObject")
    GetFileName = fso.GetFileName(strFile)
Ooops:
    Set fso = Nothing
End Function

Private Function FolderExist(strDir As String) As Boolean
    On Error GoTo Ooops
    'determine if a folder exists
    Dim fso
    Set fso = CreateObject("Scripting.FileSystemObject")
    FolderExist = fso.FolderExists(strDir)
Ooops:
    Set fso = Nothing
End Function

Private Function FileExist(strFile As String) As Boolean
    On Error GoTo Ooops
    'determine if a file exists
    Dim fso
    Set fso = CreateObject("Scripting.FileSystemObject")
    FileExist = fso.FileExists(strFile)
Ooops:
    Set fso = Nothing
End Function
